#!/usr/bin/env python

# extract-values.py - given a plain text file, list the human values it contains

# Eric Lease Morgan <emorgan@nd.edu>
# (c) University of Notre Dame; distributed under a GNU Public License

# August 6, 2025 - demonstrating some of our good work


# configure
MODEL = './model'

# require
from spacy   import load
from pathlib import Path
from sys     import argv, exit
from os.path import getsize

# get input
if len( argv ) != 2 : exit( "Usage: " + argv[ 0 ] + " <file>" )
file = argv[ 1 ]

# initialize
file           = Path( file )
nlp            = load( MODEL )
nlp.max_length = getsize( file ) + 1

# read and model the given file
with open( file ) as handle : text = handle.read()
doc = nlp( text )

# do the work
for entity in doc.ents : print( entity.text.lower() )

# done
exit()

    